﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

    Private filename As String

    Private Sub openTextFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles openTextFile.Click
        Try
            With odlgTextFile
                ' 有关属性默认值的解释，
                ' 请参见 btnRetriveFileNames_Click。

                ' 检查以确保选择的文件存在。否则对话框显示
                ' 一个警告。
                .CheckFileExists = True

                ' 检查以确保选择的路径存在。否则对话框显示
                ' 一个警告。
                .CheckPathExists = True

                ' 获取或设置默认扩展名。不包括前面的“.”。
                .DefaultExt = "txt"

                ' 是否返回链接引用的文件？如果为 False，则仅返回选择的链接
                ' 文件。如果为 True，则返回链接到 LNK 文件的文件。
                .DereferenceLinks = True

                ' 与在 VB6 中完全一样，使用一组筛选器对，中间用“|”隔开。
                ' 每个筛选器对均由一个“说明|文件规范”组成。各个筛选器对
                ' 之间使用“|”隔开。不需要在结尾使用“|”。也可以设置 FilterIndex 属性，以选择默认
                ' 筛选器。第一个筛选器的编号为 1（而不是 0）。默认值为 1。 
                .Filter = _
                "Text files (*.txt)|*.txt|All files|*.*"

                .Multiselect = False

                ' 是否在选择文件时还原原始
                ' 目录？如果为 False，则当前目录
                ' 更改为在其中选择文件的目录。
                ' 将其设置为 True 可将当前文件夹
                ' 放置在开始时该文件夹所在的位置。
                ' 默认值为 False。
                .RestoreDirectory = True

                ' 是否显示“Help”（帮助）按钮和“Read-Only”（只读）复选框？
                .ShowHelp = True
                .ShowReadOnly = False

                ' 是否在选中“Read-Only”（只读）复选框的情况下开始？
                ' 这仅在 ShowReadOnly 为 True 时有效。
                .ReadOnlyChecked = False

                .Title = "Select a file to open"

                ' 是否仅接受有效的 Win32 文件名？
                .ValidateNames = True

                If .ShowDialog = Windows.Forms.DialogResult.OK Then
                    Try
                        txtFileContents.Text = My.Computer.FileSystem.ReadAllText(.FileName)
                    Catch fileException As Exception
                        Throw fileException
                    End Try
                End If

            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, Me.Text)
        End Try
    End Sub

    Private Sub btnSaveTextFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveTextFile.Click
        Try
            With sdlgTextFile
                ' 查看演示 OpenFileDialog 控件的代码，其中有大多数属性
                ' 的使用示例，在大部分情况下，这对于两种控件来说
                ' 是相同的。

                ' 添加默认扩展名（如果用户没有添加扩展名）。
                ' 默认值为 True。
                .AddExtension = True

                ' 检查以验证输出路径是否存在。是否在创建新文件
                ' 之前进行提示？是否在覆盖之前进行提示？
                ' 默认值为 True。
                .CheckPathExists = True
                ' 默认值为 False。
                .CreatePrompt = False
                ' 默认值为 True。
                .OverwritePrompt = True
                ' 默认值为 True。
                .ValidateNames = True
                ' 默认值为 False。
                .ShowHelp = True

                ' 如果用户未提供扩展名，并且 AddExtension 属性为
                ' True，则使用此扩展名。默认值为 ""。
                .DefaultExt = "txt"

                ' 如果指定了当前文件名，则提示当前文件名。
                ' 默认值为 ""。
                .FileName = filename

                ' 默认值为 ""。
                .Filter = _
                "Text files (*.txt)|*.txt|" & _
                "All files|*.*"
                .FilterIndex = 1

                If .ShowDialog() = Windows.Forms.DialogResult.OK Then
                    My.Computer.FileSystem.WriteAllText(.FileName, txtFileContents.Text, False)
                End If

            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, Me.Text)
        End Try
    End Sub

    Private Sub btnSelectColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectColor.Click
        ' 使用整数数组初始化 CustomColors。
        ' 注意，这些颜色的格式与 .NET 颜色
        ' 不同 -- 这些颜色是旧的 VB6 类型的
        ' 颜色值。例如，0 表示黑色，255 表示
        ' 红色，等等。可以使用 VB6 RGB 函数
        ' 创建这些值。

        ' 对于此示例，将红色、绿色和蓝色放在自定义的
        ' 颜色区域中。
        Static CustomColors() As Integer = _
         {RGB(255, 0, 0), RGB(0, 255, 0), RGB(0, 0, 255)}

        Try
            With cdlgText
                ' 初始化选择的颜色，以便与文本框前景色
                ' 当前使用的颜色匹配。
                ' 默认值为 Black。
                .Color = txtFileContents.ForeColor

                ' 使用先前提供的数组在对话框中填充自定义颜色。
                .CustomColors = CustomColors

                '是否允许用户创建自定义颜色？
                ' 默认值为 True。
                .AllowFullOpen = True

                ' 是否显示所有基本颜色？
                ' 默认值为 False。
                .AnyColor = True

                ' 如果为 True，显示对话框时也会打开自定义
                ' 颜色设置端。
                ' 默认值为 False。
                .FullOpen = False

                ' 将用户限制为只能使用纯色。
                ' 默认值为 False。
                .SolidColorOnly = True

                ' 如果 ShowHelp 为 True，则控件会显示其“Help”（帮助）
                ' 按钮，而且您可以响应控件的 HelpRequest 事件。
                ' 默认值为 False。
                .ShowHelp = True

                If .ShowDialog() = Windows.Forms.DialogResult.OK Then
                    txtFileContents.ForeColor = .Color

                    ' 存储自定义颜色以供将来使用。
                    CustomColors = .CustomColors
                End If

                ' 重置对话框中的所有颜色。
                ' 这不是必须的，但这样可确保对话框处于
                ' 已知状态以便下一次使用。
                cdlgText.Reset()

            End With

            ' 您可以使用少得多的代码完成此任务。
            ' 这至少会为您设置
            ' 颜色 -- 只是不提供任何选项：
            'With cdlgText
            '  .Color = txtFileContents.ForeColor
            '  If .ShowDialog() = DialogResult.OK Then
            '    txtFileContents.ForeColor = .Color
            '  End If
            'End With

        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, Me.Text)
        End Try
    End Sub

    Private Sub btnSelectFont_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectFont.Click
        Try
            With fdlgText
                ' 初始化对话框，以便与文本框中
                ' 使用的字体匹配。

                .Font = txtFileContents.Font
                ' 默认值为 Black。
                .Color = txtFileContents.ForeColor

                ' 允许用户选择颜色。
                ' 默认值为 False。
                .ShowColor = True

                ' 在对话框上显示“Apply”（应用）按钮。
                ' 默认值为 False。
                .ShowApply = True

                ' 允许用户选择效果。
                ' 默认值为 True。
                .ShowEffects = True

                ' 显示“Help”（帮助）按钮。
                ' 默认值为 False。
                .ShowHelp = True

                ' 允许用户更改字符集，但
                ' 不允许模拟、矢量字体或
                ' 垂直字体。
                ' 默认值为 True。
                .AllowScriptChange = True
                ' 默认值为 True。
                .AllowSimulations = False
                ' 默认值为 True。
                .AllowVectorFonts = False
                ' 默认值为 True。
                .AllowVerticalFonts = False

                ' 允许使用固定字体和非等宽字体，并且
                ' 只允许使用现有的字体。
                ' 也可以设置可选择的最小和最大
                ' 字体大小。在本示例中，这些是
                ' 任意值。

                ' 默认值为 False。
                .FixedPitchOnly = False
                ' 默认值为 False。
                .FontMustExist = True

                ' 这两项的默认值均为 0。
                .MaxSize = 48
                .MinSize = 8

                ' 显示该对话框，然后根据请求
                ' 固定字体。
                If .ShowDialog = Windows.Forms.DialogResult.OK Then
                    txtFileContents.Font = .Font
                End If

            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, Me.Text)
        End Try
    End Sub

    Private Sub btnBrowseFolders_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBrowseFolders.Click
        Try
            With fldlgList
                ' 通常情况下，创建新的 FolderBrowserDialog 后，
                ' 应将 RootFolder 设置为开始浏览的
                ' 位置。
                ' 可以从包含常用信息的系统专用文件夹列表
                ' 中进行选择，系统专用文件夹是诸如 Program Files、Programs、
                ' System 或 Startup 的文件夹。
                .RootFolder = Environment.SpecialFolder.Personal

                ' 也可以选择将 Description 属性设置为
                ' 向用户提供附加说明。
                .Description = "Select the directory you want to use as the default."

                ' 可以使用 ShowNewFolderButton 属性来控制
                ' 用户是否能够通过“New Folder”（新建文件夹）按钮创建新文件夹。
                .ShowNewFolderButton = True

                If .ShowDialog = Windows.Forms.DialogResult.OK Then
                    txtDirectory.Text = .SelectedPath
                End If

            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, Me.Text)
        End Try
    End Sub

    Private Sub btnRetriveFileNames_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRetriveFileNames.Click
        Try
            With odlgFileNames
                ' 可以设置初始文件夹，虽然您有时候可能不希望这样做。
                ' 在本示例中，代码仅在自最后一次打开该对话框之后
                ' 设置了 DefaultFolder 值时才设置此属性。
                ' 如果不调用 Reset 方法，并且已经使用初始目录
                ' 选择了一个文件，则初始目录不会影响该
                ' 对话框。
                .Reset()
                .InitialDirectory = My.Computer.FileSystem.SpecialDirectories.Temp

                ' 如果用户没有键入扩展名，则在文件名中添加默认扩展名。
                ' 默认值为 True。
                .AddExtension = True

                ' 检查以确保选择的文件存在。否则对话框显示
                ' 一个警告。
                ' 默认值为 True。
                .CheckFileExists = True

                ' 检查以确保选择的路径存在。否则对话框显示
                ' 一个警告。
                ' 默认值为 True。
                .CheckPathExists = True

                '获取或设置默认扩展名。不包括前面的“.”。
                ' 默认值为 ""。
                .DefaultExt = "txt"

                ' 是否返回链接引用的文件？如果为 False，则仅返回选择的链接
                ' 文件。如果为 True，则返回链接到 LNK 文件的文件。
                ' 默认值为 True。
                .DereferenceLinks = True

                ' 与在 VB6 中完全一样，使用一组筛选器对，中间用“|”隔开。
                ' 每个筛选器对均由一个“说明|文件规范”组成。各个筛选器对
                ' 之间使用“|”隔开。不需要在结尾使用“|”。也可以设置 FilterIndex 属性，以选择默认
                ' 筛选器。第一个筛选器的编号为 1（而不是 0）。默认值为 1。
                ' 默认值为 ""。
                .Filter = _
                "Text files (*.txt)|*.txt|" & _
                "All files|*.*"

                ' 如果要允许用户选择多个文件，请将此设置为 True。
                ' 如果将此设置为 True，则使用对话框的 FileNames 属性检索选择的
                ' 文件。
                ' 默认值为 False。
                .Multiselect = True

                ' 是否在选择文件时还原原始
                ' 目录？如果为 False，则当前目录
                ' 更改为在其中选择文件的目录。
                ' 将其设置为 True 可将当前文件夹
                ' 放置在开始时该文件夹所在的位置。
                ' 默认值为 False。
                .RestoreDirectory = True

                ' 是否显示“Help”（帮助）按钮和“Read-Only”（只读）复选框？
                ' 默认值均为 False。
                .ShowHelp = True
                .ShowReadOnly = False

                ' 是否在选中“Read-Only”（只读）复选框的情况下开始？
                ' 这仅在 ShowReadOnly 为 True 时有效。
                ' 默认值为 False。
                ' .ReadOnlyChecked = False

                ' 默认值为 ""。
                .Title = "Select a file"

                ' 是否仅接受有效的 Win32 文件名？
                ' 默认值为 True。
                .ValidateNames = True

                If .ShowDialog() = Windows.Forms.DialogResult.OK Then
                    ' 这里您具有一个选择。可以使用
                    ' FileName 或 FileNames 属性获取选择的
                    ' 名称，或者可以使用 OpenFile 方法将文件
                    ' 作为只读流打开。
                    lstFiles.DataSource = .FileNames

                    ' 也可以按如下所示编写代码，
                    ' 以依次通过选择的文件名：
                    'Dim strName As String
                    'For Each strName In .FileNames
                    '    lstFiles.Items.Add(strName)
                    'Next
                End If

            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, Me.Text)
        End Try
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        End
    End Sub
End Class
